/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.fcs.chatlet;

import com.ibm.hwmca.fw.fcs.chatlet.ChatletException;
import com.ibm.hwmca.fw.fcs.chatlet.ChatletPacket;
import com.ibm.hwmca.fw.fcs.chatlet.ChatletRequestTimeoutException;
import com.ibm.hwmca.fw.fcs.chatlet.ChatletResponse;

public class ChatletRequest
extends ChatletPacket {
    ChatletResponse response = null;
    boolean terminate = false;

    public ChatletRequest() {
        this.requestType = 0;
    }

    synchronized void postResponse(ChatletResponse response) {
        this.response = response;
        this.notifyAll();
    }

    synchronized void destroy() {
        this.terminate = true;
        this.notifyAll();
    }

    synchronized ChatletResponse blockForResponse(int timeout) throws ChatletException {
        if (timeout > 0) {
            long started = System.currentTimeMillis();
            long remainingWait = timeout;
            while (!this.terminate && this.response == null && remainingWait > 0L) {
                try {
                    this.wait(remainingWait);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                remainingWait = (long)timeout - (System.currentTimeMillis() - started);
            }
            if (!this.terminate && this.response == null) {
                throw new ChatletRequestTimeoutException("Chatlet request timed out, no response.");
            }
        } else {
            while (!this.terminate && this.response == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        if (this.terminate) {
            throw new ChatletException("Chatlet terminated while response outstanding");
        }
        return this.response;
    }
}

